<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:javaFile="javaFile:java.io.File" xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon" exclude-result-prefixes="saxon javaFile">
	<xsl:script language="java" implements-prefix="javaFile" src="java:java.io.File"/>
	<xsl:output method="xml" indent="yes"/>
	<!--<xsl:include href = "publishtest.xsl"/>-->
	<!-- GET AUTHOR FILE NAME -->
	<!-- TODO: adjust for new directory structure -->
	<xsl:template name="getauthorfile">
		<xsl:choose>
			<xsl:when test="self::namespace">
				<xsl:value-of select="concat('chopdata/', @name,'.xml')"/>
			</xsl:when>
			<xsl:when test="self::const or self::constant or self::variable[parent::namespace] or self::routine or self::method[parent::namespace] or self::procedure[parent::namespace] or self::function[parent::namespace]">
				<!-- self::method[not(parent::namespace) catches routines which doctrack calls global methods -->
				<xsl:variable name="namespace">
					<xsl:value-of select="ancestor::namespace/@name"/>
				</xsl:variable>
				<xsl:variable name="subdir">
					<xsl:choose>
						<xsl:when test="self::const | self::constant">
							<xsl:text>constants</xsl:text>
						</xsl:when>
						<xsl:when test="self::variable">
							<xsl:text>variables</xsl:text>
						</xsl:when>
						<xsl:when test="self::routine | self::method | self::procedure | self::function">
							<xsl:text>routines</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:message>
            ERROR!  Not constant, variable or routine! <xsl:value-of select="@name"/>
							</xsl:message>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:value-of select="concat('chopdata/', 
                            $namespace, '/', $subdir, '/', @name, '.xml')"/>
			</xsl:when>
			<xsl:when test="self::interface or self::class">
				<xsl:variable name="namespace">
					<!--
        <xsl:if test="@namespace">
          <xsl:value-of select="@namespace"/>
        </xsl:if>
        <xsl:if test="not(@namespace)">
        -->
					<!-- look up to parents -->
					<xsl:value-of select="ancestor::namespace/@name"/>
					<!--        </xsl:if>-->
				</xsl:variable>
				<xsl:value-of select="concat('chopdata/', 
                            $namespace, '/classes/', @name, '/', @name, '.xml')"/>
			</xsl:when>
			<xsl:when test="self::struct">
				<xsl:variable name="namespace">
					<!-- look up to parents -->
					<xsl:value-of select="ancestor::namespace/@name"/>
				</xsl:variable>
				<xsl:value-of select="concat('chopdata/', 
                            $namespace, '/types/', @name, '/', @name, '.xml')"/>
			</xsl:when>
			<xsl:when test="self::type or self::enum or self::set or self::classref or self::array">
				<!-- check explicitly for variety attribute?? -->
				<xsl:variable name="namespace">
					<!-- look up to parents -->
					<xsl:value-of select="ancestor::namespace/@name"/>
				</xsl:variable>
				<!-- must try both locations for a type!!! -->
				<xsl:variable name="topleveldir">
					<xsl:value-of select="concat('chopdata/', 
                            $namespace, '/types/', @name, '.xml')"/>
				</xsl:variable>
				<xsl:variable name="structdir">
					<xsl:value-of select="concat('chopdata/', 
                              $namespace, '/types/', @name, '/', @name, '.xml')"/>
				</xsl:variable>
				<xsl:variable name="toplevel" select="javaFile:new($topleveldir)"/>
				<xsl:variable name="struct" select="javaFile:new($structdir)"/>
				<xsl:choose>
					<xsl:when test="javaFile:exists($toplevel)">
						<xsl:value-of select="$topleveldir"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$structdir"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="not(parent::namespace)">
						<xsl:variable name="namespace">
							<xsl:value-of select="ancestor::namespace/@name"/>
						</xsl:variable>
						<xsl:variable name="classinterfaceorstruct">
							<xsl:choose>
								<xsl:when test="../@name">
									<xsl:value-of select="../@name"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../@name"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="subdir">
							<xsl:choose>
								<xsl:when test="ancestor::class">
									<xsl:value-of select="'classes'"/>
								</xsl:when>
								<xsl:when test="ancestor::interface">
									<xsl:value-of select="'classes'"/>
								</xsl:when>
								<xsl:when test="ancestor::type | ancestor::struct">
									<xsl:value-of select="'types'"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:message>
										<xsl:copy-of select="."/>
									</xsl:message>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="elementtype">
							<xsl:choose>
								<xsl:when test="self::function or self::procedure or self::constructor or self::destructor or self::method">
									<xsl:text>Methods</xsl:text>
								</xsl:when>
								<xsl:when test="self::property">
									<xsl:text>Properties</xsl:text>
								</xsl:when>
								<xsl:when test="self::event">
									<xsl:text>Events</xsl:text>
								</xsl:when>
								<xsl:when test="self::field or self::variable">
									<xsl:text>Fields</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="concat('UNKNOWN_',name(.))"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:value-of select="concat('chopdata/', 
                                $namespace, '/', $subdir, '/', 
                                $classinterfaceorstruct, 
                                '/', $elementtype, '/', 
                                $classinterfaceorstruct, '.', @name,
                                '.xml')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="namespace" select="ancestor::namespace/@name"/>
						<xsl:value-of select="concat('chopdata/', 
                                $namespace, '/', @name, '.xml')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
